#include <bits/stdc++.h>

#define int long long

using namespace std;

struct Point {
    int x, y;
    bool operator<(const Point& p) const {
        return x < p.x || (x == p.x && y < p.y);
    }
};

int cross(const Point& o, const Point& a, const Point& b) {
    return (a.x - o.x) * (b.y - o.y) - (a.y - o.y) * (b.x - o.x);
}

vector<Point> convexHull(vector<Point>& points) {
    sort(points.begin(), points.end());
    vector<Point> lower;
    for (const auto& p : points) {
        while (lower.size() >= 2 && cross(lower[lower.size() - 2], lower[lower.size() - 1], p) <= 0)
            lower.pop_back();
        lower.push_back(p);
    }
    vector<Point> upper;
    for (int i = points.size() - 1; i >= 0; i--) {
        while (upper.size() >= 2 && cross(upper[upper.size() - 2], upper[upper.size() - 1], points[i]) <= 0)
            upper.pop_back();
        upper.push_back(points[i]);
    }
    lower.pop_back();
    upper.pop_back();

    lower.insert(lower.end(), upper.begin(), upper.end());
    return lower;
}
int convexHullArea(const vector<Point>& hull) {
    int area = 0;
    int n = hull.size();
    for (int i = 0; i < n; i++) {
        int j = (i + 1) % n;
        //cout << i << " " << j << "\n";
        area += hull[i].x * hull[j].y - hull[i].y * hull[j].x;
    }
    return area / 2;
}

int povrsinatrougla(int x1, int y1, int x2, int y2, int x3, int y3) {
    return (abs(x1 * (y2 - y3) + x2 * (y3 - y1) + x3 * (y1 - y2))) / 2;
}

signed main() {
    ios::sync_with_stdio(false);
    cin.tie(0);
    int n;
    cin >> n;
    vector<Point> tacke(n);
    for(int i = 0; i < n; i++) {
        cin >> tacke[i].x >> tacke[i].y;
    }
    vector<Point> omotac = convexHull(tacke);
    int ans = convexHullArea(omotac);
    int res = ans;
    if(n == 4) {
        //!!! URADI ZA N = 4
        for(int i = 0; i < n; i++) {
            for(int j = i + 1; j < n; j++) {
                for(int k = j + 1; k < n; k++) {
                    res = min(res, povrsinatrougla(tacke[i].x, tacke[i].y, tacke[j].x, tacke[j].y, tacke[k].x, tacke[k].y));
                }
            }
        }
        cout << res;
        return 0;
    }
    for(int i = 0; i < omotac.size(); i++) {
        int prev = - 1;
        if(i == 0) {
            prev = omotac.size() - 1;
        }
        else {
            prev = i - 1;
        }
        int next = - 1;
        if(i == omotac.size() - 1) {
            next = 0;
        }
        else {
            next = i + 1;
        }
        int newans = ans;
        int u1 = (omotac[i].x * omotac[next].y - omotac[i].y * omotac[next].x) / 2;
        int u2 = (omotac[prev].x * omotac[i].y - omotac[prev].y * omotac[i].x) / 2;
        int u3 = (omotac[prev].x * omotac[next].y - omotac[prev].y * omotac[next].x) / 2;
        //cout << i << " " << prev << " " << next << " " << u1 << " " << u2 << " " << u3 << "\n";
        newans -= u1;
        newans -= u2;
        newans += u3;
        res = min(res, newans);
    }
    cout << res;
}